ORCA/M Asm65816 2.1.0

0001 0000                       title 'Tool Locator Patch' 
0002 0000              *******************************************************************
0003 0000              *
0004 0000              * Copyright 1990-1992 Apple Computer, Inc.
0005 0000              * All Rights Reserved
0006 0000              *
0007 0000              *******************************************************************
0008 0000              *
0009 0000              * Tool Locator patches for ROM 3
0010 0000              * 
0011 0000              * (Some routines are also used by the ROM 1 patch.)
0012 0000              *
0013 0000              *
0014 0000              * 17-Sep-90	Dave Lyons
0015 0000              *
0016 0000              * New file for 6.0.
0017 0000              *
0018 0000              * 25-Sep-90	Dave Lyons
0019 0000              *
0020 0000              * Added GetIndMessage call.
0021 0000              *
0022 0000              * 3..4-Oct-90	Dave Lyons
0023 0000              *
0024 0000              * Implemented AcceptRequests and most of SendRequest.
0025 0000              *
0026 0000              * 10-Oct-90	Dave Lyons
0027 0000              *
0028 0000              * Finish SendRequest (implement by-name substring matching).
0029 0000              *
0030 0000              * 16-Oct-90	Dave Lyons
0031 0000              *
0032 0000              * Add a NotifyProc to call SysBeep2 (AddTBNotifyProc).
0033 0000              *
0034 0000              * 14-Nov-90	Dave Lyons
0035 0000              *
0036 0000              * Removed the JSL AddTBNotifyProc from TLBootInit (moving it to
0037 0000              * Install.asm instead).
0038 0000              *
0039 0000              * Put back all.macros.
0040 0000              *
0041 0000              * 17-Nov-90	Dave Lyons
0042 0000              *
0043 0000              * Patched out StartUpTools and ShutDownTools.
0044 0000              * Patched out LoadOneTool and LoadTools for new version
0045 0000              * number bit handling.
0046 0000              *
0047 0000              * 14-Mar-91	Dave Lyons
0048 0000              *
0049 0000              * Forced a device scan through the new $01FCDC vector before
0050 0000              * adding the SysBeep2-calling NotifyProc; this way having a disk
0051 0000              * online during boot doesn't cause a SysBeep2 "insert" call.
0052 0000              *
0053 0000              * 22-Mar-91	Dave Lyons
0054 0000              *
0055 0000              * Changed the notify proc for insert/eject to check the DIB
0056 0000              * of the device & see if it's a 5.25 drive.  If it is, we don't
0057 0000              * call SysBeep2, because bogus inserts and ejects happen frequently
0058 0000              * for these drives.
0059 0000              *
0060 0000              * 29-Mar-91	Dave Lyons
0061 0000              *
0062 0000              * Only call SysBeep2 for inserts/ejects on devices that have
0063 0000              * removable media!  (Brilliant...thanks, Greg.)
0064 0000              *
0065 0000              * 16-Apr-91	Dave Lyons
0066 0000              *
0067 0000              * Added AddTBRequestHandler and UnknownDiskReqProc to this
0068 0000              * file.  This IDs unrecognized disks within HandleDiskInsert
0069 0000              * in the Window Manager.
0070 0000              *
0071 0000              * 18-Apr-91	Dave Lyons
0072 0000              *
0073 0000              * Changed the request number in UnknownDiskReqProc to $0002,
0074 0000              * systemSaysUnknownDisk.
0075 0000              *
0076 0000              * 23-Apr-91	Dave Lyons
0077 0000              *
0078 0000              * Edited the unknown-disk messages to contain actual installer
0079 0000              * script names.
0080 0000              *
0081 0000              * 30-Apr-91	Dave Lyons
0082 0000              *
0083 0000              * Unknown disk messages:  Changed "seems" to "appears" in all
0084 0000              * messages.  Changed "use" to "read" in ISO/HS message.
0085 0000              *
0086 0000              * 23-May-91	Dave Lyons
0087 0000              *
0088 0000              * Added a missing REP #$30 that would cause a tool call to be
0089 0000              * made in 8-bit accumulator, which is normally fine, but was
0090 0000              * accidental and caused a crash with old versions of GSBug.
0091 0000              *
0092 0000              * 6-Jun-91	Dave Lyons
0093 0000              *
0094 0000              * Patched TLShutDown to call SANEShutDown first thing.
0095 0000              *
0096 0000              * Patched Save/RestoreTextState to deal with text page 1
0097 0000              * shadowing.  RestoreTextState(NIL) now does nothing.
0098 0000              *
0099 0000              * 11-Jun-91	Dave Lyons
0100 0000              *
0101 0000              * Optimized stack setup and teardown on AcceptRequests.
0102 0000              *
0103 0000              * 1-Jul-91	Dave Lyons
0104 0000              *
0105 0000              * SendRequest now returns error $0122, invalidSendRequest, if
0106 0000              * you try to send a $8000+ request by sendToAll.
0107 0000              *
0108 0000              * 8-Jul-91	Dave Lyons
0109 0000              *
0110 0000              * The UnknownDisk request proc now accepts systemSaysDeskShutDown
0111 0000              * and systemSaysDeskStartUp.  On startup, it calls ShowBootInfo
0112 0000              * with StringPtr=$80000000 to reinitialize it.  On the first
0113 0000              * shutdown, it calls SysBeep2(sbSystemStartup+sbSilence).
0114 0000              *
0115 0000              * 14-Sep-91	Dave Lyons
0116 0000              *
0117 0000              * Made TLShutDown call QDAuxShutDown for some BONEHEADS who
0118 0000              * are making ShutDownTools shut down the tool locator, and
0119 0000              * *then* they are shutting down QuickDraw, which would have
0120 0000              * shut down QDAux for them, but it's already gone.  (They
0121 0000              * never asked for QDAux in the first place, but Window Mgr
0122 0000              * loaded it so AlertWindow could use icons.)
0123 0000              *
0124 0000              * 17-Sep-91	Dave Lyons
0125 0000              *
0126 0000              * Moved following functions to Tool.Setup instead of here:
0127 0000              *  LoadTools, LoadOneTool, UnloadOneTool, StartUpTools,
0128 0000              *  ShutDownTools, GetMsgHandle, AcceptRequests, SendRequest.
0129 0000              *  Also moved TBNotifyProc and AddTBRequestHandler/UnknownDiskProc.
0130 0000              *
0131 0000              * 18-Sep-91	Dave Lyons
0132 0000              *
0133 0000              * Added a placeholder proc to be linked into the very beginning
0134 0000              * of the Patches segment of Tool.Setup, so that no tool patch
0135 0000              * will start at the beginning of the segment, and therefore at
0136 0000              * the beginning of the bank (can't be dispatched to correctly).
0137 0000              *
0138 0000              * 23-Sep-91	Dave Lyons
0139 0000              *
0140 0000              * SendRequest, on dispatch to a request proc, sets D to $CCCC
0141 0000              * and Bank to $FE, to help catch request procs that mistakenly
0142 0000              * assume the B or D values are defined or useful.  They are not.
0143 0000              *
0144 0000              * 1-Oct-91	Dave Lyons
0145 0000              *
0146 0000              * Changed MS-DOS unrecognized-disk message.
0147 0000              *
0148 0000              * 13-Oct-91	Dave Lyons
0149 0000              *
0150 0000              * AcceptRequests--if NamePtr and ReqProc are both NIL, we remove
0151 0000              * all the procs registered under the specified UserID.
0152 0000              *
0153 0000              * 24-Oct-91	Dave Lyons
0154 0000              *
0155 0000              * UnknownDisk proc can identify UniDOS (DOS 3.3 on floppy) disks
0156 0000              * (reads block $0110 instead of $0088 looking for the VTOC).
0157 0000              *
0158 0000              * 2-Dec-91	Dave Lyons (for 6.0d60)
0159 0000              *
0160 0000              * Hack MessageCenter so that deleting message 1 (list of Pascal
0161 0000              * strings to Open/Print, from Finder) automatically deletes
0162 0000              * message $11 (new mesage, list of GS/OS strings to Open/Print
0163 0000              * from Finder). -- This is needed so that a new app doesn't
0164 0000              * accidentally act on message $11 after transferring out of
0165 0000              * an old application that didn't know about the new message.
0166 0000              *
0167 0000              * 27-Jan-92	Dave Lyons (for 6.0d66)
0168 0000              *
0169 0000              * SendRequest was failing to fill in the recvCount field of
0170 0000              * the output buffer, in the case that the stop-after-one flag
0171 0000              * is set and somebody accepts the request.  Fixed.
0172 0000              *
0173 0000              * 5-Feb-92	Dave Lyons
0174 0000              *
0175 0000              * Version $0301 for 6.0 final (linked into both TS2 and TS3).
0176 0000              *
0177 0000              ******************************************************************
0178 0000              *
0179 0000              * 17-Feb-92	Dave Lyons
0180 0000              *
0181 0000              * Version $8302 for 6.0.1d1.
0182 0000              *
0183 0000              * Changed 6.0 to 6.1 in a couple of you-have-no-FST messaages.
0184 0000              *
0185 0000              * 9-Jun-92	Dave Lyons
0186 0000              *
0187 0000              * UnknownDisk procedure:  Updated some messages to read 6.0.1
0188 0000              * instead of 6.1.  Updated MS-DOS message to tell them to install
0189 0000              * the MS-DOS FST using the Installer.
0190 0000              *
0191 0000              * 18-Jan-93	Steve Stephenson
0192 0000              *
0193 0000              * Optimized IsThisTarget, mcGetFirstMessage, and mcGetNextMessage
0194 0000              * for speed (also shrunk them in size).
0195 0000              *
0196 0000              * 2-Apr-93 DAL
0197 0000              *
0198 0000              * Version $0302 for 6.0.1.
0199 0000              *
0200 0000              ******************************************************************
0201 0000              ******************************************************************
0202 0000
0203 0000                       include 'all.macros' 
0204 0000                       include ':::sys.equs.asm' 
0205 0000
0206 0000              incbusy  equ   $e10064
0207 0000              MessNotFound equ   $0111                ;error code
0208 0000              srqNameTooLong equ   $0113              ;for AcceptRequests
0209 0000              reqNotAccepted equ   $0120              ;SendRequest error code
0210 0000              duplicateName equ   $0121               ;AcceptRequests duplicate string
0211 0000              invalidSendRequest equ   $0122          ;can't send $8000+ to everybody
0212 0000
0213 0000              LocatorVersion equ   $0302              ;2-Apr-93 DAL
0214 0000
0215 0000
0216 0000              ****************************************************************
0217 0000              *
0218 0000              * GODDAMMIT, I need to put a NOP at the beginning of the
0219 0000              * Patches segment to prevent a tool patch from starting at the
0220 0000              * first byte of the segment & maybe the bank, where you can't
0221 0000              * dispatch to it.
0222 0000              *
0223 0000              ****************************************************************
0224 0000              GODDAMMIT PROC EXPORT 
0225 0000 EA                    nop   
0226 0001                       Endp 
0227 0001
0228 0001              ****************************************************************
0229 0001              *
0230 0001              * GetMsgHandle for both ROM 1 and ROM 3
0231 0001              *
0232 0001              * $1A01 GetMsgHandle(Flags,MsgRef/4):Handle
0233 0001              *
0234 0001              * Inputs:
0235 0001              *
0236 0001              *     WORD Flags = %0000 0000 0000 00mm
0237 0001              *        mm 00 = get the MsgRef-th message
0238 0001              *        mm 01 = get message with Message Type of MsgRef
0239 0001              *        mm 10 = get message with name MsgRef points to
0240 0001              *        mm 11 = reserved
0241 0001              *
0242 0001              *     LONG MsgRef:
0243 0001              *        index or integer or pointer to Pascal string (depends on Flags)
0244 0001              *
0245 0001              * Outputs:
0246 0001              *     LONG Handle = handle belonging to the system (don't fiddle with it!)
0247 0001              *                   (NIL if error)
0248 0001              *
0249 0001              * Description:
0250 0001              *
0251 0001              ****************************************************************
0252 0001              GetMsgHandle proc export 
0253 0001                       import mcGetFirstMessage 
0254 0001                       import mcGetNextMessage 
0255 0001                       import DerefYA 
0256 0001
0257 0001                       DefineStack 
0258 0001              temp     long 
0259 0001              sizeLocals EndLocals 
0260 0001
0261 0001              saveDPage word 
0262 0001              RTL1     block 3 
0263 0001              RTL2     block 3 
0264 0001              MsgRef   long 
0265 0001              Flags    word 
0266 0001              ResultHandle long 
0267 0001
0268 0001 22 64 00 E1           jsl   incbusy
0269 0005 0B                    phd   
0270 0006 3B                    tsc   
0271 0007 38                    sec   
0272 0008 E9 04 00              sbc   #sizeLocals
0273 000B 1B                    tcs   
0274 000C 5B                    tcd   
0275 000D
0276 000D 20 96 05              jsr   mcGetFirstMessage
0277 0010 B0 15                 bcs   @notFound
0278 0012
0279 0012 84 15        @next    sty   <ResultHandle+2
0280 0014 85 13                 sta   <ResultHandle
0281 0016 20 3C 05              jsr   CheckMessage
0282 0019 A2 00 00              ldx   #0                       ;anticipate success
0283 001C 90 10                 bcc   @exit
0284 001E
0285 001E A4 15                 ldy   <ResultHandle+2
0286 0020 A5 13                 lda   <ResultHandle
0287 0022 20 AA 05              jsr   mcGetNextMessage
0288 0025 90 EB                 bcc   @next
0289 0027
0290 0027 A2 11 01     @notFound ldx   #MessNotFound
0291 002A 64 15                 stz   <ResultHandle+2
0292 002C 64 13                 stz   <ResultHandle
0293 002E
0294 002E              @exit     
0295 002E 3B                    tsc                            ;get rid of local variables
0296 002F 18                    clc   
0297 0030 69 04 00              adc   #sizeLocals
0298 0033 1B                    tcs   
0299 0034 2B                    pld   
0300 0035 A0 06 00              ldy   #6                       ;strip 6 bytes
0301 0038 5C 80 01 E1           jml   ToBusyStrip
0302 003C
0303 003C              *
0304 003C              * CheckMessage
0305 003C              *
0306 003C              * Inputs:  YA = handle to a message to check
0307 003C              *               (also in ResultHandle)
0308 003C              *          Flags and MsgRef tell us what to check
0309 003C              *
0310 003C              * Outputs:
0311 003C              *          CLC if we found the message
0312 003C              *
0313 003C 20 B0 05     CheckMessage jsr   DerefYA
0314 003F 84 03                 sty   <temp+2
0315 0041 85 01                 sta   <temp
0316 0043 A5 11                 lda   <flags
0317 0045 29 03 00              and   #%00000011
0318 0048 0A                    asl   a
0319 0049 AA                    tax   
0320 004A 7C 4D 05              jmp   (Filter,x)
0321 004D
0322 004D 55 05 5C 05  Filter   DC W:byIndex,byType,byName,byReserved
0323 0055
0324 0055 C6 0D        byIndex  dec   <MsgRef
0325 0057 18                    clc   
0326 0058 F0 01                 beq   @found
0327 005A 38                    sec   
0328 005B 60           @found   rts   
0329 005C
0330 005C A0 04 00     byType   ldy   #4                       ;offset to type
0331 005F B7 01                 lda   [<temp],y
0332 0061 C5 0D                 cmp   <MsgRef
0333 0063 18                    clc   
0334 0064 F0 01                 beq   @found
0335 0066 38                    sec   
0336 0067 60           @found   rts   
0337 0068              *
0338 0068              * byName--return CLC if message at <temp was created by
0339 0068              *         MessageByName and the name matches <MsgRef
0340 0068              *
0341 0068 A0 04 00     byName   ldy   #4                       ;offset to type
0342 006B B7 01                 lda   [<temp],y
0343 006D 10 25                 bpl   @noMatch                 ;$8000+ = MessageByName types
0344 006F C9 B0 B0              cmp   #$b0b0                   ;Claris stole Msg Type $B0B0
0345 0072 F0 20                 beq   @noMatch
0346 0074 18                    clc   
0347 0075 A5 01                 lda   <temp
0348 0077 69 08 00              adc   #8
0349 007A 85 01                 sta   <temp
0350 007C 90 02                 bcc   @ok
0351 007E E6 03                 inc   <temp+2
0352 0080 E2 30        @ok      sep   #$30
0353 0082                       longa off 
0354 0082                       longi off 
0355 0082 A7 0D                 lda   [<MsgRef]
0356 0084 A8                    tay   
0357 0085 B7 0D        @compare lda   [<MsgRef],y
0358 0087 D7 01                 cmp   [<temp],y
0359 0089 D0 07                 bne   @cmpFail
0360 008B 88                    dey   
0361 008C 10 F7                 bpl   @compare
0362 008E                       longa on 
0363 008E                       longi on 
0364 008E C2 30                 rep   #$30
0365 0090 18                    clc   
0366 0091 60                    rts   
0367 0092
0368 0092 C2 30        @cmpFail rep   #$30
0369 0094                       longa on 
0370 0094                       longi on                       ;fall into sec/rts
0371 0094              @noMatch  
0372 0094 38           byReserved sec   
0373 0095 60                    rts   
0374 0096
0375 0096                       EndP 
0376 0096
0377 0096              ********************************************************************
0378 0096              *
0379 0096              * Get YA=handle to first message (return SEC = none)
0380 0096              *
0381 0096              * The handle to the first message is stored in the
0382 0096              * Memory Manager's WAP.
0383 0096              *
0384 0096              ****************************************************************
0385 0096              mcGetFirstMessage proc export 
0386 0096
0387 0096              ;	pha
0388 0096              ;	pha	;result space (long)
0389 0096              ;	pea	0	;system tool
0390 0096              ;	pea	2	;memory manager
0391 0096              ;	_GetWAP
0392 0096              ;	pla
0393 0096              ;	ply
0394 0096              ;	bne	@ok
0395 0096              ;	sec
0396 0096              ;@ok	rts
0397 0096
0398 0096              *** optimized 18-Jan-93 SS
0399 0096                       import DerefYA 
0400 0096
0401 0096 AF CA 03 E1           lda   >$e103c8+2
0402 009A A8                    tay   
0403 009B AF C8 03 E1           lda   >$e103c8                 ;get ptr to WAPT
0404 009F 18                    clc   
0405 00A0 69 08 00              adc   #2*4                     ;get Memory Mgr's WAP
0406 00A3 90 01                 bcc   @nohi
0407 00A5 C8                    iny   
0408 00A6 20 B0 05     @nohi    jsr   DerefYA                  ;dig out the handle
0409 00A9 60                    rts   
0410 00AA
0411 00AA              *** end 18-Jan-93
0412 00AA
0413 00AA                       EndP 
0414 00AA
0415 00AA              *
0416 00AA              * Advance YA to next message (return SEC = none)
0417 00AA              *
0418 00AA              mcGetNextMessage proc export 
0419 00AA
0420 00AA 20 B0 05              jsr   DerefYA
0421 00AD 90 01                 bcc   DerefYA
0422 00AF 60                    rts   
0423 00B0
0424 00B0              *** optimized 15-Jan-93 SS
0425 00B0
0426 00B0                       export DerefYA 
0427 00B0              ;DerefYA	phd
0428 00B0              ;	phy
0429 00B0              ;	pha
0430 00B0              ;	tsc
0431 00B0              ;	tcd
0432 00B0              ;	ldy	#2
0433 00B0              ;	lda	[1],y
0434 00B0              ;	pha
0435 00B0              ;	lda	[1]
0436 00B0              ;	ply		;conditions Z for bne
0437 00B0              ;	clc
0438 00B0              ;	bne	@notNIL
0439 00B0              ;	sec
0440 00B0              ;@notNIL	plx
0441 00B0              ;	plx
0442 00B0              ;	pld
0443 00B0              ;	rts
0444 00B0
0445 00B0 8B           DerefYA  phb                            ;save B
0446 00B1 5A                    phy                            ;reset to Y bnk
0447 00B2 AB                    plb                            ;(invalid byte still on stk)
0448 00B3 AA                    tax                            ;addr lo
0449 00B4 BD 00 00              lda   |0,x
0450 00B7 BC 02 00              ldy   |2,x                     ;hi=0=end
0451 00BA 18                    clc   
0452 00BB D0 01                 bne   @notNIL
0453 00BD 38                    sec   
0454 00BE AB           @notNIL  plb                            ;pop garbage byte
0455 00BF AB                    plb                            ;restore B
0456 00C0 60                    rts   
0457 00C1
0458 00C1              *** end 15-Jan-93
0459 00C1
0460 00C1                       endp 
0461 00C1
0462 00C1
0463 00C1              ****************************************************************
0464 00C1              *
0465 00C1              * AcceptRequests for both ROM 1 and ROM 3
0466 00C1              *
0467 00C1              * $1B01 AcceptRequests(@NameStr,UserID,@ReqProc)
0468 00C1              *
0469 00C1              * Description:
0470 00C1              *
0471 00C1              * Uses MessageByName to create a message based on the
0472 00C1              * input parameters.  The name is $FF ">" followed by
0473 00C1              * the NameStr, and the UserID and ReqProc come after
0474 00C1              * that.
0475 00C1              *
0476 00C1              * If ReqProc is NIL, removes the corresponding entry
0477 00C1              * instead.
0478 00C1              *
0479 00C1              * Special case--if NamePtr and ReqProc are *both* NIL,
0480 00C1              * then we remove all the procs registered under the
0481 00C1              * specified UserID.
0482 00C1              *
0483 00C1              ****************************************************************
0484 00C1              AcceptRequests proc export 
0485 00C1
0486 00C1                       DefineStack 
0487 00C1
0488 00C1              sizeLocals EndLocals 
0489 00C1              saveDPage word 
0490 00C1              RTL1     block 3 
0491 00C1              RTL2     block 3 
0492 00C1              ReqProc  long 
0493 00C1              UserID   word 
0494 00C1              NamePtr  long 
0495 00C1
0496 00C1 22 64 00 E1           jsl   incbusy
0497 00C5 0B                    phd   
0498 00C6
0499 00C6 3B                    tsc   
0500 00C7                       if sizeLocals<>0 then 
0501 00C7                       sec   
0502 00C7                       sbc   #sizeLocals
0503 00C7                       tcs   
0504 00C7                       endif 
0505 00C7
0506 00C7 5B                    tcd   
0507 00C8
0508 00C8 8B                    phb   
0509 00C9 4B                    phk   
0510 00CA AB                    plb   
0511 00CB
0512 00CB              *** added 13-Oct-91 DAL -- allow removing procs by ID
0513 00CB A5 10                 lda   <NamePtr+1
0514 00CD 05 0A                 ora   <ReqProc+1
0515 00CF D0 0B                 bne   @notRemoveByID
0516 00D1 A5 0D                 lda   <UserID
0517 00D3 20 4E 06              jsr   RemoveByUserID
0518 00D6 A2 00 00              ldx   #0
0519 00D9 82 69 00              brl   @exit                    ;error code in X
0520 00DC              @notRemoveByID  
0521 00DC              *** end 13-Oct-91
0522 00DC
0523 00DC A2 13 01              ldx   #srqNameTooLong          ;anticipate name too long
0524 00DF A7 0F                 lda   [NamePtr]
0525 00E1 29 FF 00              and   #$00ff
0526 00E4 C9 3F 00              cmp   #63
0527 00E7 B0 5C                 bcs   @exit
0528 00E9 1A                    inc   a
0529 00EA 1A                    inc   a
0530 00EB 48                    pha                            ;save length+2
0531 00EC
0532 00EC E2 20                 sep   #$20
0533 00EE 8D CA 06              sta   msgString
0534 00F1 C2 20                 rep   #$20
0535 00F3
0536 00F3 A8                    tay   
0537 00F4 F0 08                 beq   @copied
0538 00F6 B7 0F        @copy    lda   [<NamePtr],y
0539 00F8 99 CC 06              sta   msgString+2,y
0540 00FB 88                    dey   
0541 00FC D0 F8                 bne   @copy
0542 00FE              @copied   
0543 00FE
0544 00FE 7A                    ply                            ;length+2
0545 00FF A5 0D                 lda   <UserID
0546 0101 99 CB 06              sta   msgString+1,y
0547 0104 A5 09                 lda   <ReqProc
0548 0106 99 CD 06              sta   msgString+1+2,y
0549 0109 A5 0B                 lda   <ReqProc+2
0550 010B 99 CF 06              sta   msgString+1+4,y
0551 010E
0552 010E A7 0F                 lda   [<NamePtr]
0553 0110 29 FF 00              and   #$00ff
0554 0113 18                    clc   
0555 0114 69 0B 00              adc   #11
0556 0117 8D C8 06              sta   msgBuffer
0557 011A
0558 011A A5 0A                 lda   <ReqProc+1
0559 011C D0 16                 bne   @Install
0560 011E
0561 011E              *** Remove
0562 011E
0563 011E A0 00 00              ldy   #0                       ;don't create
0564 0121 20 B4 06              jsr   MessByName               ;return A=flag, Y=ID, X=error
0565 0124 F4 03 00              pea   3                        ;delete message
0566 0127 5A                    phy                            ;message id
0567 0128 48                    pha   
0568 0129 48                    pha                            ;handle (ignored)
0569 012A A2 01 15 22           _MessageCenter 
0570 0131 AA                    tax   
0571 0132 80 11                 bra   @exit
0572 0134
0573 0134              *** Install
0574 0134
0575 0134 A0 00 00     @Install ldy   #0                       ;don't create msg
0576 0137 20 B4 06              jsr   MessByName               ;return A=flag, Y=ID, X=error
0577 013A A2 21 01              ldx   #duplicateName           ;error
0578 013D 90 06                 bcc   @exit                    ;no error?  Duplicate name!
0579 013F
0580 013F A0 01 00              ldy   #1                       ;okay to create msg
0581 0142 20 B4 06              jsr   MessByName               ;return A=flag, Y=ID, X=error
0582 0145
0583 0145              ** X = error code
0584 0145
0585 0145 AB           @exit    plb   
0586 0146
0587 0146                       if sizeLocals<>0 then 
0588 0146                       tsc                            ;get rid of local variables
0589 0146                       clc   
0590 0146                       adc   #sizeLocals
0591 0146                       tcs   
0592 0146                       endif 
0593 0146
0594 0146 2B                    pld   
0595 0147 A0 0A 00              ldy   #10                      ;strip 10 bytes
0596 014A 5C 80 01 E1           jml   ToBusyStrip
0597 014E
0598 014E              *** added 13-Oct-91 DAL
0599 014E 8D B2 06     RemoveByUserID sta   IDToRemove
0600 0151 0B                    phd   
0601 0152 48                    pha   
0602 0153 48                    pha   
0603 0154 48                    pha   
0604 0155 48                    pha   
0605 0156 3B                    tsc   
0606 0157 5B                    tcd   
0607 0158              @ThisMsg equ   1
0608 0158              @temp    equ   5
0609 0158
0610 0158 20 96 05     @RestartTheSearch jsr   mcGetFirstMessage
0611 015B B0 4F                 bcs   @removedByID
0612 015D 84 03        @remove1 sty   <@ThisMsg+2
0613 015F 85 01                 sta   <@ThisMsg
0614 0161 20 B0 05              jsr   DerefYA
0615 0164 84 07                 sty   <@temp+2
0616 0166 85 05                 sta   <@temp
0617 0168 A0 04 00              ldy   #4
0618 016B B7 05                 lda   [<@temp],y               ;get message type
0619 016D 10 34                 bpl   @tryNext                 ;not a named message!
0620 016F A0 09 00              ldy   #9
0621 0172 B7 05                 lda   [<@temp],y               ;check SendRequest signature
0622 0174 C9 FF 3E              cmp   #$3EFF                   ;$FF ">" signature
0623 0177 D0 2A                 bne   @tryNext
0624 0179
0625 0179 A0 08 00              ldy   #8                       ;offset to name length
0626 017C B7 05                 lda   [<@temp],y
0627 017E 29 FF 00              and   #$00FF
0628 0181 18                    clc   
0629 0182 69 09 00              adc   #9                       ;offset past end of name (to user id)
0630 0185 A8                    tay   
0631 0186 B7 05                 lda   [<@temp],y
0632 0188 CD B2 06              cmp   IDToRemove
0633 018B D0 16                 bne   @tryNext
0634 018D
0635 018D F4 03 00              pea   3                        ;delete message
0636 0190 A0 04 00              ldy   #4
0637 0193 B7 05                 lda   [<@temp],y
0638 0195 48                    pha                            ;pushed message number (type)
0639 0196 48                    pha   
0640 0197 48                    pha                            ;handle (not used)
0641 0198 A2 01 15 22           _MessageCenter 
0642 019F B0 0B                 bcs   @removedByID             ;shouldn't happen (give up)
0643 01A1 80 B5                 bra   @RestartTheSearch        ;handle is invalid, start over
0644 01A3
0645 01A3 A4 03        @tryNext ldy   <@ThisMsg+2
0646 01A5 A5 01                 lda   <@ThisMsg
0647 01A7 20 AA 05              jsr   mcGetNextMessage
0648 01AA 90 B1                 bcc   @remove1
0649 01AC 68           @removedByID pla   
0650 01AD 68                    pla   
0651 01AE 68                    pla   
0652 01AF 68                    pla   
0653 01B0 2B                    pld   
0654 01B1 60                    rts   
0655 01B2
0656 01B2 00 00        IDToRemove DC W:0
0657 01B4              *** end 13-Oct-91
0658 01B4
0659 01B4 48           MessByName pha                          ;space for result flag
0660 01B5 48                    pha                            ;space for result ID
0661 01B6 5A                    phy                            ;CreateIt flag
0662 01B7 F4 02 00 F4           pushlong #MsgBuffer 
0663 01BD A2 01 17 22           _MessageByName 
0664 01C4 AA                    tax                            ;error code
0665 01C5 7A                    ply                            ;message ID created or found
0666 01C6 68                    pla                            ;Created flag
0667 01C7 60                    rts   
0668 01C8
0669 01C8 00 00        msgBuffer DC W:0                        ;length = [NameStr]+11
0670 01CA 00           msgString DC B:0                        ;length byte = [NameStr]+2
0671 01CB FF 3E                 DC B:$ff,'>'
0672 01CD 00 00 00 00           ds 63+2+4
0673 0257
0674 0257                       endp 
0675 0257
0676 0257              ****************************************************************
0677 0257              *
0678 0257              * SendRequest for both ROM 1 and ROM 3
0679 0257              *
0680 0257              * $1C01 SendRequest(ReqCode,How,Target/4,@In,@Out)
0681 0257              *
0682 0257              * Inputs:
0683 0257              *
0684 0257              * Outputs:
0685 0257              *
0686 0257              * Description:
0687 0257              *
0688 0257              ****************************************************************
0689 0257              SendRequest proc export 
0690 0257
0691 0257                       import mcGetFirstMessage 
0692 0257                       import mcGetNextMessage 
0693 0257
0694 0257                       DefineStack 
0695 0257              TempPtr  long 
0696 0257              temp     long 
0697 0257              count    word 
0698 0257              sizeLocals EndLocals 
0699 0257              saveDPage word 
0700 0257              RTL1     block 3 
0701 0257              RTL2     block 3 
0702 0257              OutPtr   long 
0703 0257              InPtr    long 
0704 0257              Target   long 
0705 0257              SendHow  word 
0706 0257              ReqCode  word 
0707 0257
0708 0257 22 64 00 E1           jsl   incbusy
0709 025B 0B                    phd   
0710 025C 3B                    tsc   
0711 025D 38                    sec   
0712 025E E9 0A 00              sbc   #sizeLocals
0713 0261 1B                    tcs   
0714 0262 5B                    tcd   
0715 0263
0716 0263 64 09                 stz   <count
0717 0265
0718 0265              *** added 1-Jul-91 DAL -- don't allow sendToAll + reqCode>=$8000
0719 0265 A5 21                 lda   <reqCode
0720 0267 10 0C                 bpl   @validSRQ
0721 0269 A5 1F                 lda   <sendHow
0722 026B 29 03 00              and   #3
0723 026E D0 05                 bne   @validSRQ
0724 0270 A2 22 01              ldx   #invalidSendRequest
0725 0273 80 27                 bra   @exit
0726 0275              @validSRQ  
0727 0275              *** end of 1-Jul-91 DAL
0728 0275
0729 0275 20 96 05              jsr   mcGetFirstMessage
0730 0278 B0 18                 bcs   @triedAll
0731 027A
0732 027A 84 07        @next    sty   <temp+2
0733 027C 85 05                 sta   <temp
0734 027E 20 B2 07              jsr   SendReq
0735 0281 B0 06                 bcs   @doNext
0736 0283
0737 0283              * request was accepted
0738 0283
0739 0283 E6 09                 inc   <count
0740 0285
0741 0285 A5 1F                 lda   <SendHow
0742 0287 30 10                 bmi   @noError                 ;stop when it's accepted
0743 0289
0744 0289 A4 07        @doNext  ldy   <temp+2
0745 028B A5 05                 lda   <temp
0746 028D 20 AA 05              jsr   mcGetNextMessage
0747 0290 90 E8                 bcc   @next
0748 0292
0749 0292              @triedAll  
0750 0292
0751 0292              ;** If there's an output buffer, fill in the acceptedCount field
0752 0292              ;	lda	<OutPtr+1
0753 0292              ;	beq	@noOutBuff
0754 0292              ;	lda	<count
0755 0292              ;	sta	[<OutPtr]
0756 0292              ;@noOutBuff
0757 0292
0758 0292 A2 20 01              ldx   #reqNotAccepted          ;anticipate nobody accepted
0759 0295 A5 09                 lda   <count
0760 0297 F0 03                 beq   @exit
0761 0299
0762 0299 A2 00 00     @noError ldx   #0
0763 029C              @exit     
0764 029C              *** moved here 27-Jan-92 DAL from above--set the recvCount in dataOut
0765 029C              ** If there's an output buffer, fill in the acceptedCount field
0766 029C A5 14                 lda   <OutPtr+1
0767 029E F0 04                 beq   @noOutBuff
0768 02A0 A5 09                 lda   <count
0769 02A2 87 13                 sta   [<OutPtr]
0770 02A4              @noOutBuff  
0771 02A4              *** end 27-Jan-92
0772 02A4 3B                    tsc                            ;get rid of local variables
0773 02A5 18                    clc   
0774 02A6 69 0A 00              adc   #sizeLocals
0775 02A9 1B                    tcs   
0776 02AA 2B                    pld   
0777 02AB A0 10 00              ldy   #16                      ;strip 16 bytes
0778 02AE 5C 80 01 E1           jml   ToBusyStrip
0779 02B2
0780 02B2              *
0781 02B2              * SendReq
0782 02B2              *
0783 02B2              * YA are a message handle.  Try sending the request to this if it's a
0784 02B2              * ReqProc message.
0785 02B2              *
0786 02B2              * Return carry clear if the message is accepted.
0787 02B2              *
0788 02B2 20 B0 05     SendReq  jsr   DerefYA
0789 02B5 84 03                 sty   <TempPtr+2
0790 02B7 85 01                 sta   <TempPtr
0791 02B9
0792 02B9 A0 04 00              ldy   #4
0793 02BC B7 01                 lda   [<TempPtr],y
0794 02BE 10 3D                 bpl   Noper                    ;not a $8000+ message type
0795 02C0 A0 09 00              ldy   #9
0796 02C3 B7 01                 lda   [<TempPtr],y
0797 02C5 C9 FF 3E              cmp   #$3eff                   ;$FF ">" signature
0798 02C8 D0 33                 bne   Noper
0799 02CA
0800 02CA 20 FF 07              jsr   IsThisTarget
0801 02CD B0 2F                 bcs   Noper1                   ;bypass redundant SEC (18-Jan-93 SS)
0802 02CF
0803 02CF A0 08 00              ldy   #8
0804 02D2 B7 01                 lda   [<TempPtr],y
0805 02D4 29 FF 00              and   #$00ff
0806 02D7 18                    clc   
0807 02D8 69 0C 00              adc   #12                      ;offset to proc+1
0808 02DB A8                    tay   
0809 02DC B7 01                 lda   [<TempPtr],y
0810 02DE AA                    tax   
0811 02DF 88                    dey   
0812 02E0 B7 01                 lda   [<TempPtr],y
0813 02E2
0814 02E2 8B                    phb                            ;save B around reqProc (23-Sep-91 DAL)
0815 02E3 0B                    phd                            ;save D around reqProc (23-Sep-91 DAL)
0816 02E4
0817 02E4 F4 00 00              pea   0                        ;result space
0818 02E7 D4 21                 pei   <ReqCode
0819 02E9 D4 19                 pei   <InPtr+2
0820 02EB D4 17                 pei   <InPtr
0821 02ED D4 15                 pei   <OutPtr+2
0822 02EF D4 13                 pei   <OutPtr
0823 02F1 22 63 08 02           jsl   JumpToProc
0824 02F5 68                    pla   
0825 02F6
0826 02F6 2B                    pld                            ;restore our D (23-Sep-91 DAL)
0827 02F7 AB                    plb                            ;restore our B (23-Sep-91 DAL)
0828 02F8
0829 02F8 49 00 80              eor   #$8000
0830 02FB 0A                    asl   a
0831 02FC 60                    rts   
0832 02FD
0833 02FD 38           Noper    sec   
0834 02FE 60           Noper1   rts   
0835 02FF
0836 02FF              *
0837 02FF              * IsThisTarget--return CLC if the message at <TempPtr is one
0838 02FF              * we should call.  We already know it's a ReqProc message.
0839 02FF              *
0840 02FF A5 1F        IsThisTarget lda   <SendHow
0841 0301 29 03 00              and   #%00000011
0842 0304 D0 02                 bne   @notToAll
0843 0306 18           @Yes     clc                            ;%00 = send to all
0844 0307 60                    rts   
0845 0308
0846 0308 3A           @notToAll dec   a
0847 0309 D0 3E                 bne   @notByName               ;%01 = send by name substring
0848 030B
0849 030B              * compare names: return CLC if Target is a substring of TempPtr+8 string
0850 030B              * (TempPtr+8 pstring has $FF $3E as the first two characters; we ignore
0851 030B              * them)
0852 030B
0853 030B              ;	pei	<TempPtr+2	;save old TempPtr
0854 030B              ;	pei	<TempPtr
0855 030B              ;	clc
0856 030B              ;	lda	<TempPtr
0857 030B              ;	adc	#8	;offset to name
0858 030B              ;	sta	<TempPtr
0859 030B              ;	bcc	@1
0860 030B              ;	inc	<TempPtr+2
0861 030B              ;@1
0862 030B              ;	longa off
0863 030B              ;	longi off
0864 030B              ;	sep	#$30
0865 030B              ;	ldy	#0
0866 030B              ;@nextChar	tya
0867 030B              ;	cmp	[<Target]
0868 030B              ;	bcs	@decideYes	;run out of chars in Target: send
0869 030B              ;	inc	a
0870 030B              ;	inc	a
0871 030B              ;	cmp	[<TempPtr]
0872 030B              ;	dec	a
0873 030B              ;	dec	a
0874 030B              ;	bcs	@decideNo	;run out of chars in candidate: don't send
0875 030B              ;	iny
0876 030B              ;	lda	[<Target],y
0877 030B              ;	iny
0878 030B              ;	iny
0879 030B              ;	cmp	[<TempPtr],y
0880 030B              ;	php
0881 030B              ;	dey
0882 030B              ;	dey
0883 030B              ;	plp
0884 030B              ;	beq	@nextChar	;keep looking
0885 030B              ;
0886 030B              ;@decideNo	sec
0887 030B              ;	dc.b	$24	;BIT <$xx hides next byte
0888 030B              ;@decideYes	clc
0889 030B              ;@decided	rep	#$30
0890 030B              ;	longa on
0891 030B              ;	longi on
0892 030B              ;	pla
0893 030B              ;	sta	<TempPtr
0894 030B              ;	pla
0895 030B              ;	sta	<TempPtr+2
0896 030B              ;	rts		;Return value = carry
0897 030B
0898 030B              *** optimized 18-Jan-93 SS
0899 030B
0900 030B 18                    clc                            ;(for both adc and nil case)
0901 030C A7 1B                 lda   [<Target]
0902 030E 29 FF 00              and   #$00ff
0903 0311 F0 35                 beq   @defaultYes              ;Target NIL is a match
0904 0313 69 0B 00              adc   #8+2+1                   ;length + offset to str + first 2 chars + 1 past
0905 0316 A8                    tay                            ;hold spot into TempPtr str where Target ends
0906 0317 A6 1B                 ldx   <Target                  ;set X for start of str
0907 0319 A5 1D                 lda   <Target+2
0908 031B 8B                    phb                            ;save B
0909 031C 48                    pha                            ;reset to Target's B
0910 031D AB                    plb   
0911 031E 5A                    phy   
0912 031F                       longa off 
0913 031F E2 20                 sep   #$20
0914 0321 A0 08 00              ldy   #8
0915 0324 B7 01                 lda   [<TempPtr],y             ;this Temp's length
0916 0326 3A                    dec   a                        ;minus 2 for the lead chars
0917 0327 3A                    dec   a
0918 0328 DD 00 00              cmp   |0,x                     ;long enuf to encompass the Target?
0919 032B 90 13                 bcc   @decideNo                ; no, reject
0920 032D C8                    iny                            ; yes, step to first actual char
0921 032E C8                    iny   
0922 032F C8                    iny   
0923 0330 B7 01        @nxtchar lda   [<TempPtr],y             ;compare chars
0924 0332 DD 01 00              cmp   |1,x
0925 0335 D0 09                 bne   @decideNo                ;not same, reject
0926 0337 E8                    inx   
0927 0338 C8                    iny                            ;bump indexes
0928 0339 98                    tya   
0929 033A C3 01                 cmp   1,s                      ;at end of Target?
0930 033C F0 04                 beq   @decideYes               ; yes, got a match
0931 033E 90 F0                 bcc   @nxtchar                 ; not yet, keep checking
0932 0340 38           @decideNo sec   
0933 0341 90                    DC B:$90                       ;fake to skip over next byte
0934 0342 18           @decideYes clc   
0935 0343                       longa on 
0936 0343 C2 20                 rep   #$20
0937 0345 68                    pla                            ;fix stack
0938 0346 AB                    plb   
0939 0347 AB                    plb                            ;restore B
0940 0348 60           @defaultYes rts   
0941 0349
0942 0349              *** end 18-Jan-93
0943 0349
0944 0349 3A           @notByName dec   a
0945 034A D0 15                 bne   @dontSend                ;%10 = send by MemID
0946 034C
0947 034C              * compare user IDs
0948 034C
0949 034C A0 08 00              ldy   #8                       ;offset to string length
0950 034F B7 01                 lda   [<TempPtr],y
0951 0351 29 FF 00              and   #$00ff
0952 0354 18                    clc   
0953 0355 69 09 00              adc   #9                       ;offset to User ID
0954 0358 A8                    tay                            ;added 20-Dec-90 DAL
0955 0359 B7 01                 lda   [<TempPtr],y
0956 035B C5 1B                 cmp   <Target
0957 035D D0 02                 bne   @DontSend
0958 035F 18                    clc   
0959 0360 60                    rts   
0960 0361
0961 0361 38           @DontSend sec   
0962 0362 60                    rts   
0963 0363
0964 0363              *
0965 0363              * JumpToProc--Long jump to address in XA
0966 0363              *
0967 0363 DA           JumpToProc phx   
0968 0364 8B                    phb                            ;just a scratch byte
0969 0365 3A                    dec   a
0970 0366 83 01                 sta   1,s
0971 0368              *** set up garbage values for undefined registers! (23-Sep-91 DAL)
0972 0368 A9 CC CC              lda   #$CCCC                   ;garbage D value
0973 036B 5B                    tcd   
0974 036C F4 FE FE              pea   $FEFE
0975 036F AB                    plb   
0976 0370 AB                    plb                            ;set B to $FE (ROM)
0977 0371              *** end 23-Sep-91
0978 0371 6B                    rtl   
0979 0372
0980 0372                       EndP 
0981 0372
0982 0372
0983 0372              ****************************************************************
0984 0372              *
0985 0372              * AddTBNotifyProc for both ROM 1 and ROM 3
0986 0372              *
0987 0372              * Description:
0988 0372              *
0989 0372              * Adds a GS/OS Notify Proc that calls SysBeep2 in response
0990 0372              * to various OS events.  This makes it easy to customize sounds
0991 0372              * (or whatever) in the system.
0992 0372              *
0993 0372              ****************************************************************
0994 0372              AddTBNotifyProc proc export 
0995 0372
0996 0372              *** Force a device scan so we get any "inserts" out of the way
0997 0372              *** before we start calling SysBeep2 for every insert.  Having
0998 0372              *** a disk online when you boot shouldn't count as an insert
0999 0372              *** for SysBeep2 purposes. (14-Mar-91 DAL)
1000 0372
1001 0372              *** 1-Apr-91 DAL -- use the Misc Tools call instead of the OS Service
1002 0372 48                    pha   
1003 0373 A2 03 3D 22           _ScanDevices 
1004 037A 68                    pla   
1005 037B
1006 037B 22 A8 00 E1           _AddNotifyProcGS anpParms 
1007 0385 6B                    rtl   
1008 0386
1009 0386 01 00        anpParms DC W:1
1010 0388 8C 08 02 00           DC L:TBNotifyProc
1011 038C
1012 038C              ****************************************************************
1013 038C              *
1014 038C              * TBNotifyProc -- call SysBeep2 as appropriate
1015 038C              *
1016 038C              ****************************************************************
1017 038C 00 00 00 00  TBNotifyProc DC L:0                     ;reserved
1018 0390 00 00                 DC W:0                         ;reserved
1019 0392 5A A5                 DC W:$A55A
1020 0394 3E 00 00 00           DC L:$0000003E                 ;shutdown, eject, insert, OS switches
1021 0398 00 00 00 00  EventCode DC L:0
1022 039C              ProcEntry  
1023 039C
1024 039C              * Need to check for eject/insert Apple 5.25 device--don't call SysBeep2
1025 039C
1026 039C AF 98 08 02           lda   >EventCode
1027 03A0 C9 08 00              cmp   #$0008
1028 03A3 F0 05                 beq   @isInsertEject
1029 03A5 C9 10 00              cmp   #$0010
1030 03A8 D0 18                 bne   @notInsertEject
1031 03AA
1032 03AA 0B           @isInsertEject phd   
1033 03AB A9 00 BD              lda   #$bd00                   ;hard-coded GS/OS direct page location
1034 03AE 5B                    tcd   
1035 03AF A0 34 00              ldy   #$0034                   ;offset of device_id in DIB
1036 03B2 B7 20                 lda   [$20],y                  ;$20 points to current DIB
1037 03B4              *** added 29-Mar-91 DAL
1038 03B4 F0 08                 beq   @willSkip
1039 03B6              ; check for removable media now
1040 03B6 A0 08 00              ldy   #$0008                   ;offset of characteristics in DIB
1041 03B9 B7 20                 lda   [$20],y                  ;$20 points to current DIB
1042 03BB 29 04 00              and   #$0004                   ;bit 2 set for removable media
1043 03BE              *** end of 29-Mar-91 DAL
1044 03BE 2B           @willSkip pld   
1045 03BF AA                    tax   
1046 03C0 F0 13                 beq   @skipit                  ;device_id $0000 is AppleDisk 5.25 drive
1047 03C2
1048 03C2 AF 98 08 02  @notInsertEject lda   >EventCode
1049 03C6 A2 0F 80              ldx   #$8010-1                 ;beepType = $8010 + bit number
1050 03C9 E8           @findbit inx   
1051 03CA 4A                    lsr   a
1052 03CB 90 FC                 bcc   @findbit
1053 03CD DA                    phx   
1054 03CE A2 03 38 22           _SysBeep2 
1055 03D5 6B           @skipit  rtl   
1056 03D6
1057 03D6                       EndP 
1058 03D6
1059 03D6
1060 03D6              ****************************************************************
1061 03D6              ****************************************************************
1062 03D6              *
1063 03D6              * AddTBRequestHandler -- install the toolbox's AcceptRequests
1064 03D6              *	     routine.
1065 03D6              *
1066 03D6              ****************************************************************
1067 03D6              AddTBRequestHandler proc export 
1068 03D6                       import UnknownDiskReqProc 
1069 03D6
1070 03D6 F4 02 00 F4           pushlong #myReqProcName 
1071 03DC 48                    pha   
1072 03DD A2 02 02 22           _MMStartUp 
1073 03E4 F4 02 00 F4           pushlong #UnknownDiskReqProc 
1074 03EA A2 01 1B 22           _AcceptRequests 
1075 03F1 6B                    rtl   
1076 03F2
1077 03F2 12 41 70 70  myReqProcName DC B:18,'Apple~UnknownDisk~'
1078 0405
1079 0405                       EndP 
1080 0405
1081 0405              **************************************************************
1082 0405              *
1083 0405              * UnknownDiskReqProc
1084 0405              *
1085 0405              * by Dave Lyons, 13-Apr-91
1086 0405              *
1087 0405              * When this gets called, dataIn contains the device number
1088 0405              * of a disk on which the Volume call returned error $52, or
1089 0405              * possibly some other error that indicates no FST wanted to
1090 0405              * claim the thing.
1091 0405              *
1092 0405              * If we accept the request, we must put a return code at
1093 0405              * [dataOut],4:  0=eject the thing, 1=initialize, 2=erase,
1094 0405              * $ffff = leave the disk online and report no error.
1095 0405              *
1096 0405              **************************************************************
1097 0405              UnknownDiskReqProc proc export 
1098 0405
1099 0405              systemSaysUnknownDisk equ $0002  
1100 0405
1101 0405              fsid_ProDOS equ   $0001
1102 0405              fsid_DOS33 equ   $0002
1103 0405              fsid_DOS32 equ   $0003
1104 0405              fsid_Pascal equ   $0004
1105 0405              fsid_MFS equ   $0005
1106 0405              fsid_HFS equ   $0006
1107 0405              fsid_Lisa equ   $0007
1108 0405              fsid_CPM equ   $0008
1109 0405              fsid_reserved equ   $0009
1110 0405              fsid_MSDOS equ   $000a
1111 0405              fsid_HighSierra equ   $000b
1112 0405              fsid_ISO9660 equ   $000c
1113 0405              fsid_AppleShare equ   $000d
1114 0405              fakefsid_DOS33other equ   $000e         ;not really a FSID (DOS 3.3 on unsupported device)
1115 0405
1116 0405              sig_MFS  equ   $D7D2                    ;block 2 signature
1117 0405              sig_HFS  equ   $4442                    ;block 2 signature
1118 0405
1119 0405              buffHandle equ   1
1120 0405              buffPtr  equ   buffHandle+4
1121 0405              oldDPage equ   buffPtr+4
1122 0405              RTL1     equ   oldDPage+2
1123 0405              DataOut  equ   RTL1+3
1124 0405              DataIn   equ   DataOut+4
1125 0405              Request  equ   DataIn+4
1126 0405              Result   equ   Request+2
1127 0405
1128 0405 0B                    phd   
1129 0406 48                    pha   
1130 0407 48                    pha                            ;space for buffPtr
1131 0408 48                    pha   
1132 0409 48                    pha                            ;space for buffHandle
1133 040A 3B                    tsc   
1134 040B 5B                    tcd   
1135 040C
1136 040C 8B                    phb   
1137 040D 4B                    phk   
1138 040E AB                    plb   
1139 040F
1140 040F 64 02                 stz   <buffHandle+1
1141 0411
1142 0411 A5 16                 lda   <Request
1143 0413
1144 0413              *** 8-Jul-91 DAL -- handle systemSaysDeskStartUp and systemSaysDeskShutDown
1145 0413 C9 02 05              cmp   #$0502                   ;systemSaysDeskStartUp
1146 0416 D0 12                 bne   @notDeskStart
1147 0418 F4 00 80              pea   $8000
1148 041B A9 00 00              lda   #0
1149 041E 48                    pha                            ;StringPtr = $80000000
1150 041F 48                    pha   
1151 0420 48                    pha                            ;IconPtr = nil
1152 0421 A2 03 3C 22           _ShowBootInfo                  ;initialize ShowBootInfo!
1153 0428 80 1A                 bra   @didIt
1154 042A
1155 042A C9 03 05     @notDeskStart cmp   #$0503              ;systemSaysDeskShutDown
1156 042D D0 1C                 bne   @notDeskShut
1157 042F
1158 042F AF 49 09 02           lda   >@FirstDeskShutDown
1159 0433 D0 0F                 bne   @didIt
1160 0435 1A                    inc   a
1161 0436 8F 49 09 02           sta   >@FirstDeskShutDown
1162 043A F4 31 80              pea   $8031                    ;sbSystemStartup+sbSilence
1163 043D A2 03 38 22           _SysBeep2 
1164 0444
1165 0444 38           @didIt   sec   
1166 0445 66 18                 ror   <Result
1167 0447 80 2B                 bra   @FastExit
1168 0449
1169 0449 00 00        @FirstDeskShutDown DC W:0
1170 044B
1171 044B              @notDeskShut  
1172 044B              *** end of 8-Jul-91
1173 044B
1174 044B C9 02 00              cmp   #systemSaysUnknownDisk
1175 044E D0 24                 bne   @FastExit
1176 0450
1177 0450 A5 12                 lda   <DataIn
1178 0452 F0 11                 beq   @exit
1179 0454
1180 0454 20 88 09              jsr   IdentifyTheDisk          ;returns file system ID in A
1181 0457 A8                    tay   
1182 0458 F0 0B                 beq   @exit
1183 045A
1184 045A 20 2E 0C              jsr   CheckForFST              ;input = A; output = unchanged or zero
1185 045D A8                    tay   
1186 045E F0 05                 beq   @exit
1187 0460
1188 0460 20 5D 0C              jsr   AskWhatToDo              ;returns SEC if [dataOut],4 is valid
1189 0463 66 18                 ror   <result
1190 0465
1191 0465 A5 02        @exit    lda   <buffHandle+1
1192 0467 F0 0B                 beq   @fastExit
1193 0469 D4 03                 pei   <buffHandle+2
1194 046B D4 01                 pei   <buffHandle
1195 046D A2 02 10 22           _DisposeHandle 
1196 0474
1197 0474 AB           @FastExit plb   
1198 0475 68                    pla   
1199 0476 68                    pla                            ;removed buffHandle
1200 0477 68                    pla   
1201 0478 68                    pla                            ;removed buffPtr
1202 0479 2B                    pld   
1203 047A A3 02                 lda   2,s
1204 047C 83 0C                 sta   12,s
1205 047E A3 01                 lda   1,s
1206 0480 83 0B                 sta   11,s
1207 0482 7A                    ply   
1208 0483 7A                    ply   
1209 0484 7A                    ply   
1210 0485 7A                    ply   
1211 0486 7A                    ply   
1212 0487 6B                    rtl   
1213 0488
1214 0488              ***************************************************************
1215 0488              *
1216 0488              * IdentifyTheDisk
1217 0488              *
1218 0488              * Input:  A = device number
1219 0488              *
1220 0488              * Output: A = file system ID, 0 if unknown
1221 0488              *
1222 0488              * Allocates buffHandle if necessary.  Caller will dispose.
1223 0488              *
1224 0488              ***************************************************************
1225 0488 8D E0 0B     IdentifyTheDisk sta   rbDevNum
1226 048B 8D F6 0B              sta   DInfoDevNum
1227 048E
1228 048E F4 02 00 F4           pushlong #DInfoParms 
1229 0494 F4 2C 20              pea   $202c                    ;DInfo
1230 0497 22 B0 00 E1           jsl   $e100b0
1231 049B
1232 049B 48                    pha   
1233 049C 48                    pha   
1234 049D F4 00 00              pea   0
1235 04A0 F4 00 02              pea   $0200                    ;block size
1236 04A3 48                    pha   
1237 04A4 A2 02 02 22           _MMStartUp                     ;memory ID
1238 04AB F4 00 C0              pea   $c000                    ;attributes
1239 04AE 48                    pha   
1240 04AF 48                    pha   
1241 04B0 A2 02 09 22           _NewHandle 
1242 04B7 FA                    plx   
1243 04B8 7A                    ply   
1244 04B9 90 03                 bcc   @gotbuff
1245 04BB 82 A2 00              brl   @unknown
1246 04BE 84 03        @gotbuff sty   <buffHandle+2
1247 04C0 86 01                 stx   <buffHandle
1248 04C2 A0 02 00              ldy   #2
1249 04C5 A7 01                 lda   [<buffHandle]
1250 04C7 85 05                 sta   <buffPtr
1251 04C9 8D E2 0B              sta   rbAddress
1252 04CC B7 01                 lda   [<buffHandle],y
1253 04CE 85 07                 sta   <buffPtr+2
1254 04D0 8D E4 0B              sta   rbAddress+2
1255 04D3
1256 04D3 A9 02 00              lda   #2
1257 04D6 8D EA 0B              sta   rbBlockNum
1258 04D9
1259 04D9 F4 02 00 F4  @tryAgain pushlong #rbParms 
1260 04DF F4 2F 20              pea   $202f
1261 04E2 22 B0 00 E1           jsl   $e100b0
1262 04E6 90 07                 bcc   @ok
1263 04E8 C9 2E 00              cmp   #$002e                   ;disk switched?
1264 04EB F0 EC                 beq   @tryAgain
1265 04ED 80 22                 bra   @block2failed
1266 04EF
1267 04EF A7 05        @ok      lda   [buffPtr]
1268 04F1 A2 05 00              ldx   #fsid_MFS
1269 04F4 C9 D2 D7              cmp   #sig_MFS
1270 04F7 F0 6A                 beq   @returnX
1271 04F9
1272 04F9 A2 06 00              ldx   #fsid_HFS
1273 04FC C9 42 44              cmp   #sig_HFS
1274 04FF F0 62                 beq   @returnX
1275 0501
1276 0501              ; check for Pascal
1277 0501 20 C2 0A              jsr   CheckForPascal
1278 0504 A2 04 00              ldx   #fsid_Pascal
1279 0507 90 5A                 bcc   @returnX
1280 0509
1281 0509              ; check for ProDOS
1282 0509 20 19 0B              jsr   CheckForProDOS
1283 050C A2 01 00              ldx   #fsid_ProDOS
1284 050F 90 52                 bcc   @returnX
1285 0511
1286 0511              @block2failed  
1287 0511
1288 0511              ; check for MS-DOS -- block 0 starts out $E9, or $EB $xx $90
1289 0511
1290 0511 9C EA 0B              stz   rbBlockNum
1291 0514 F4 02 00 F4  @zerotryAgain pushlong #rbParms 
1292 051A F4 2F 20              pea   $202f
1293 051D 22 B0 00 E1           jsl   $e100b0
1294 0521 90 07                 bcc   @ZeroOK
1295 0523 C9 2E 00              cmp   #$002e                   ;disk switched?
1296 0526 F0 EC                 beq   @zeroTryAgain
1297 0528 80 1F                 bra   @block0failed
1298 052A
1299 052A A7 05        @ZeroOk  lda   [buffPtr]
1300 052C 29 FF 00              and   #$00ff
1301 052F
1302 052F A2 0A 00              ldx   #fsid_MSDOS
1303 0532 C9 E9 00              cmp   #$00e9
1304 0535 F0 2C                 beq   @returnX
1305 0537 C9 EB 00              cmp   #$00eb
1306 053A D0 0D                 bne   @notMSDOS
1307 053C A0 02 00              ldy   #2
1308 053F B7 05                 lda   [buffPtr],y
1309 0541 29 FF 00              and   #$00ff
1310 0544 C9 90 00              cmp   #$0090
1311 0547 F0 1A                 beq   @returnX
1312 0549              @notMSDOS  
1313 0549              @block0failed  
1314 0549
1315 0549              ; check for DOS 3.3 (return CLC for DOS 3.3)
1316 0549 20 65 0A              jsr   CheckForDOS33
1317 054C B0 0D                 bcs   @not33
1318 054E A2 02 00              ldx   #fsid_DOS33
1319 0551 AD 08 0C              lda   DeviceID
1320 0554 F0 0D                 beq   @returnX
1321 0556 A2 0E 00              ldx   #fakefsid_DOS33other
1322 0559 80 08                 bra   @returnX
1323 055B              @not33    
1324 055B              ; check for ISO/HighSierra
1325 055B 20 87 0B              jsr   CheckForISOandHS
1326 055E 90 03                 bcc   @returnX
1327 0560
1328 0560              ; unknown disk
1329 0560
1330 0560 A2 00 00     @unknown ldx   #0
1331 0563 8A           @returnX txa   
1332 0564 60                    rts   
1333 0565
1334 0565              ***************************************************************
1335 0565              *
1336 0565              * CheckForDOS33
1337 0565              *
1338 0565              * Input: copy of block 2 in [buffPtr]
1339 0565              * Output: CLC if it's a DOS 3.3 disk (trashed buffer)
1340 0565              *
1341 0565              ***************************************************************
1342 0565 A9 88 00     CheckForDOS33 lda   #17*8               ;track 17, sector 0
1343 0568 20 71 0A              jsr   @CheckForDOSBlkA
1344 056B B0 01                 bcs   @tryUniDOS
1345 056D 60                    rts   
1346 056E A9 10 01     @tryUniDOS lda   #17*16                 ;track 17, sector 0 for UniDOS
1347 0571 8D EA 0B     @CheckForDOSBlkA sta   rbBlockNum
1348 0574 F4 02 00 F4  @zerotryAgain pushlong #rbParms 
1349 057A F4 2F 20              pea   $202f
1350 057D 22 B0 00 E1           jsl   $e100b0
1351 0581 B0 23                 bcs   @notDOS33
1352 0583
1353 0583 E2 30                 sep   #$30                     	;work with bytes
1354 0585                       LONGI OFF
1355 0585                       LONGA OFF
1356 0585
1357 0585 A2 09                 ldx   #id_tbl_end-id_values-1  ;point to last entry in id tables
1358 0587 BD AE 0A     @loop1   lda   id_offset,x              	;get offset into VTOC
1359 058A A8                    tay   
1360 058B B7 05        @loop2   lda   [buffPtr],y              	;get the actual value
1361 058D DD B8 0A              cmp   id_values,x              	;compare to the table value
1362 0590 D0 0B                 bne   @false                   	;not the same
1363 0592
1364 0592 CA           @loop3   dex   
1365 0593 30 15                 bmi   @confirmed               	;table finished
1366 0595
1367 0595 98                    tya   
1368 0596 DD AE 0A              cmp   id_offset,x              	;skip over other entries for same position
1369 0599 F0 F7                 beq   @loop3
1370 059B
1371 059B 80 EA                 bra   @loop1                   	;move on to next compare
1372 059D
1373 059D CA           @false   dex   
1374 059E 30 06                 bmi   @notDOS33
1375 05A0
1376 05A0 98                    tya   
1377 05A1 DD AE 0A              cmp   id_offset,x              	;see if there's an alternate value for that offset
1378 05A4 F0 E5                 beq   @loop2                   	;yes, get a second chance
1379 05A6
1380 05A6 C2 30        @notDOS33 rep   #$30
1381 05A8 38                    sec   
1382 05A9 60                    rts   
1383 05AA
1384 05AA C2 30        @confirmed rep   #$30
1385 05AC 18                    clc   
1386 05AD 60                    rts   
1387 05AE
1388 05AE                       longa on
1389 05AE                       longi on
1390 05AE
1391 05AE              id_offset                               ;these are offsets into the VTOC of bytes which are checked in order
1392 05AE                                                      ;to determine whether a disk is DOS 3.3 format:
1393 05AE 03                    DC B:$3                        ;DOS release #
1394 05AF 27                    DC B:$27                       ;# of T/S pairs per T/S list sector
1395 05B0 36 37                 DC B:$36,$37                   ;# of bytes per sector
1396 05B2 31 31                 DC B:$31,$31                   ;direction of track allocation (2 possible values)
1397 05B4 34 34                 DC B:$34,$34                   ;# of tracks per disk (2 possible values??)
1398 05B6 35 35                 DC B:$35,$35                   ;# of sectors per track (2 possible values??)
1399 05B8
1400 05B8
1401 05B8              id_values                               ;these are the actual values required for a DOS 3.3 disk:
1402 05B8 03                    DC B:3                         ;DOS release #
1403 05B9 7A                    DC B:$7A                       ;# of T/S pairs per T/S list sector
1404 05BA 00 01                 DC B:$00,$01                   ;# of bytes per sector
1405 05BC 01 FF                 DC B:$01,$FF                   ;direction of track allocation (2 possible values)
1406 05BE 23 32                 DC B:35,50                     ;# of tracks per disk (2 possible values??)
1407 05C0 10 20                 DC B:16,32                     ;# of sectors per track (2 possible values??)
1408 05C2              id_tbl_end  
1409 05C2
1410 05C2              ***************************************************************
1411 05C2              *
1412 05C2              * CheckForPascal
1413 05C2              *
1414 05C2              * This is the id_block routine borrowed from the Pascal FST.
1415 05C2              *
1416 05C2              * Input: copy of block 2 in [buffPtr]
1417 05C2              * Output: CLC if it's a Pascal disk
1418 05C2              *
1419 05C2              ***************************************************************
1420 05C2              io_file_count equ   $10                 ; offset to number of files on volume
1421 05C2
1422 05C2 A0 06 00     CheckForPascal ldy   #$06
1423 05C5 B7 05                 lda   [buffPtr],y
1424 05C7 29 FF 00              and   #$FF
1425 05CA C9 08 00              cmp   #$08                     ; is the title of the volume <= 7 chars?
1426 05CD B0 46                 bcs   notPascal
1427 05CF C9 01 00              cmp   #$01                     ; is the title at least 1 char?
1428 05D2 90 41                 bcc   notPascal
1429 05D4
1430 05D4 18                    clc                            ; add 7 to length so that I can
1431 05D5 69 07 00              adc   #$07                     ; use g_volumeName as a max value for
1432 05D8 8D DC 0B              sta   temp                     ; the y index register
1433 05DB
1434 05DB C8           loop     iny                            ; check to see that the name consists
1435 05DC 98                    tya                            ; of legal chars only
1436 05DD CD DC 0B              cmp   temp
1437 05E0 B0 29                 bcs   chkFileCnt
1438 05E2 B7 05                 lda   [buffPtr],y
1439 05E4 29 FF 00              and   #$FF
1440 05E7 C9 30 00     checkDigit cmp   #$30                   ; is the char an ascii digit?
1441 05EA 90 29                 bcc   notPascal
1442 05EC C9 3A 00              cmp   #$3A
1443 05EF B0 02                 bcs   checkUpper
1444 05F1 80 E8                 bra   loop
1445 05F3 C9 41 00     checkUpper cmp   #$41                   ; is the char upper case ascii?
1446 05F6 90 1D                 bcc   notPascal
1447 05F8 C9 5B 00              cmp   #$5b
1448 05FB B0 02                 bcs   checkLower
1449 05FD 80 DC                 bra   loop
1450 05FF C9 61 00     checkLower cmp   #$61                   ; is the char lower case ascii?
1451 0602 90 11                 bcc   notPascal
1452 0604 C9 7B 00              cmp   #$7b
1453 0607 B0 0C                 bcs   notPascal
1454 0609 80 D0                 bra   loop
1455 060B
1456 060B A0 10 00     chkFileCnt ldy   #io_file_count
1457 060E B7 05                 lda   [buffPtr],y
1458 0610 C9 4E 00              cmp   #78                      ; are there <= 77 files in the directory?
1459 0613 90 02                 bcc   isPascal
1460 0615 38           notPascal sec   
1461 0616 60                    rts   
1462 0617 18           isPascal clc   
1463 0618 60                    rts   
1464 0619
1465 0619
1466 0619              ***************************************************************
1467 0619              *
1468 0619              * CheckForProDOS
1469 0619              *
1470 0619              * Return CLC if it's a ProDOS disk
1471 0619              *
1472 0619              ***************************************************************
1473 0619 D4 07        CheckForProDOS pei   <buffPtr+2
1474 061B D4 05                 pei   <buffPtr
1475 061D 20 27 0B              jsr   CheckProDOS2
1476 0620 68                    pla   
1477 0621 85 05                 sta   <buffPtr
1478 0623 68                    pla   
1479 0624 85 07                 sta   <buffPtr+2               ;restore old buffPtr, return carry status from CheckProDOS2
1480 0626 60                    rts   
1481 0627
1482 0627 A7 05        CheckProDOS2 lda   [buffPtr]            ;load backward link
1483 0629 D0 53                 bne   notProDOS
1484 062B A0 21 00              ldy   #$0021                   ;offset to minimum version
1485 062E B7 05                 lda   [buffPtr],y
1486 0630 29 FF 00              and   #$00FF
1487 0633 D0 49                 bne   notProDOS
1488 0635
1489 0635              ; Now that we have checked both the backward link and version we now
1490 0635              ; need to adjust the pointer to point to the storage/name length field
1491 0635              ; within the block.
1492 0635
1493 0635 18                    clc   
1494 0636 A5 05                 lda   buffPtr
1495 0638 69 04 00              adc   #$0004
1496 063B 85 05                 sta   buffPtr
1497 063D 90 02                 bcc   ar
1498 063F E6 07                 inc   buffPtr+2
1499 0641
1500 0641 A7 05        ar       lda   [buffPtr]                ;load storage/name length
1501 0643 A8                    tay   
1502 0644 29 F0 00              and   #$00F0
1503 0647 C9 F0 00              cmp   #$00F0                   ;is it a volume directory type?
1504 064A D0 32                 bne   notProDOS
1505 064C 98                    tya   
1506 064D 29 0F 00              and   #$000F                   ;isolate file name length
1507 0650 F0 2C                 beq   notProDOS                ;must be $01 to $0F
1508 0652 A8                    tay   
1509 0653              ;
1510 0653              ; Now we need to verify that the name is a valid ProDOS filename
1511 0653              ;
1512 0653 B7 05        ProNameLoop lda   [buffPtr],y
1513 0655 29 FF 00              and   #$00FF
1514 0658 C9 41 00              cmp   #'A'
1515 065B 90 14                 bcc   numeric
1516 065D C9 5B 00              cmp   #'Z'+1
1517 0660 B0 1C                 bcs   notProDOS
1518 0662 88                    dey   
1519 0663 D0 EE                 bne   ProNameLoop
1520 0665
1521 0665              ; If we get here then we need to check both the entry length and
1522 0665              ; entries per block.  If everything is OK then we will call a routine
1523 0665              ; that will build a new vcr or mark the vcr as active
1524 0665
1525 0665 A0 1F 00     its_mine ldy   #$0023-4                 ;index to entry length
1526 0668 B7 05                 lda   [buffPtr],y
1527 066A C9 27 0D              cmp   #$0D27                   ;both entry length and entry per blk
1528 066D D0 0F                 bne   notProDOS
1529 066F 18                    clc                            ;it's a ProDOS disk
1530 0670 60                    rts   
1531 0671
1532 0671 C9 30 00     numeric  cmp   #'0'
1533 0674 90 0A                 bcc   period
1534 0676 C9 3A 00              cmp   #'9'+1
1535 0679 B0 03                 bcs   notProDOS
1536 067B 88           continue dey   
1537 067C D0 D5                 bne   ProNameLoop
1538 067E
1539 067E 38           notProDOS sec   
1540 067F 60                    rts   
1541 0680
1542 0680 C9 2E 00     period   cmp   #'.'
1543 0683 D0 F9                 bne   notProDOS
1544 0685 80 F4                 bra   continue
1545 0687
1546 0687
1547 0687              ***************************************************************
1548 0687              *
1549 0687              * CheckForISOandHS
1550 0687              *
1551 0687              * Return: SEC if unrecognized
1552 0687              *         CLC and X=fsid if it's High Sierra or ISO 9660
1553 0687              *
1554 0687              ***************************************************************
1555 0687              CheckForISOandHS  
1556 0687
1557 0687              vol_id_end_0 equ   13                   ;Offset to end of 'CDROM' string.
1558 0687              vol_id_end_1 equ   5                    ;Offset to end of 'CD001' string.
1559 0687
1560 0687 A9 40 00              lda   #64
1561 068A 8D EA 0B              sta   rbBlockNum
1562 068D F4 02 00 F4  @zerotryAgain pushlong #rbParms 
1563 0693 F4 2F 20              pea   $202f
1564 0696 22 B0 00 E1           jsl   $e100b0
1565 069A B0 32                 bcs   @notHS
1566 069C
1567 069C              *
1568 069C              * Ok, now look at the Volume Structure Standard Identifier.
1569 069C              * Is it 'CDROM' (High Sierra)?
1570 069C              *
1571 069C                       longa off                      ;Set 8 bit A.
1572 069C E2 20                 sep   #$20
1573 069E
1574 069E A2 04 00              ldx   #4                       ;Point to end of string.
1575 06A1 A0 0D 00              ldy   #vol_id_end_0            ;Point to end of identifier.
1576 06A4 B7 05        @check_hs lda   [buffPtr],y             ;Get byte.
1577 06A6 DD D2 0B              cmp   hs_string,x              ;Match?
1578 06A9 D0 0B                 bne   @iso                     ;Nope, so not High Sierra.
1579 06AB 88                    dey                            ;Yes, done all?
1580 06AC CA                    dex   
1581 06AD 10 F5                 bpl   @check_hs                ;No, so loop.
1582 06AF C2 30                 rep   #$30
1583 06B1 A2 0B 00              ldx   #fsid_HighSierra         ;Yes, so it's High Sierra.
1584 06B4 18                    clc   
1585 06B5 60                    rts   
1586 06B6              *
1587 06B6              * No, is it 'CD001' (ISO)?
1588 06B6              *
1589 06B6 A2 04 00     @iso     ldx   #4                       ;Point to end of string.
1590 06B9 A0 05 00              ldy   #vol_id_end_1            ;Point to end of identifier.
1591 06BC B7 05        @check_iso lda   [buffPtr],y            ;Get byte.
1592 06BE DD D7 0B              cmp   iso_string,x             ;Match?
1593 06C1 D0 0B                 bne   @notHS                   ;Nope, so not ISO either.
1594 06C3 88                    dey                            ;Yes, done all?
1595 06C4 CA                    dex   
1596 06C5 10 F5                 bpl   @check_iso               ;No, so loop.
1597 06C7 C2 30                 rep   #$30
1598 06C9 A2 0C 00              ldx   #fsid_ISO9660
1599 06CC 18                    clc   
1600 06CD 60                    rts   
1601 06CE
1602 06CE C2 30        @notHS   rep   #$30                     ;added REP #$30 23-May-91 DAL
1603 06D0 38                    sec   
1604 06D1 60                    rts   
1605 06D2
1606 06D2                       longa on 
1607 06D2
1608 06D2 43 44 52 4F  hs_string DC B:'CDROM'                  ;Must match this for High Sierra.
1609 06D7 43 44 30 30  iso_string DC B:'CD001'                 ;Must match this for ISO.
1610 06DC
1611 06DC
1612 06DC              ***************************************************************
1613 06DC
1614 06DC 00 00        temp     DC W:0                         ;used by ID-disk routines
1615 06DE
1616 06DE 06 00        rbParms  DC W:6                         ;pcount
1617 06E0 00 00        rbDevNum DC W:0                         ;device number
1618 06E2 00 00 00 00  rbAddress DC L:0                        ;buffer address
1619 06E6 00 02 00 00           DC L:$200                      ;request count
1620 06EA 00 00 00 00  rbBlockNum DC L:0                       ;starting block
1621 06EE 00 02                 DC W:$200                      ;block size
1622 06F0 00 00 00 00           DC L:0                         ;transfer count
1623 06F4
1624 06F4 08 00        DInfoParms DC W:8
1625 06F6 00 00        DInfoDevNum DC W:0                      ;device number
1626 06F8 0A 0C 02 00           DC L:FormatDeviceBuffer
1627 06FC 00 00        DInfoChar DC W:0
1628 06FE 00 00 00 00           DC L:0                         ;total blocks
1629 0702 00 00                 DC W:0                         ;slot num
1630 0704 00 00                 DC W:0                         ;unit num
1631 0706 00 00                 DC W:0                         ;version
1632 0708 00 00        DeviceID DC W:0                         ;dev_id
1633 070A
1634 070A 24 00        FormatDeviceBuffer DC W:36
1635 070C              devname   
1636 070C 00 00 00 00  FormatDeviceName DS B:34
1637 072E
1638 072E              ***************************************************************
1639 072E              *
1640 072E              * CheckForFST
1641 072E              *
1642 072E              * Input: file system ID in A
1643 072E              *
1644 072E              * Output: if FST not installed, unchanged file system ID in A
1645 072E              *         if FST installed, A=0
1646 072E              *
1647 072E              * This is used to prevent us from displaying a "please install
1648 072E              * fst Blah" when they already have it installed.
1649 072E              *
1650 072E              ***************************************************************
1651 072E 8D 55 0C     CheckForFST sta   targetFST
1652 0731 9C 59 0C              stz   fstnum_FSTInfo
1653 0734 EE 59 0C     @search  inc   fstnum_FSTInfo
1654 0737 F4 02 00 F4           pushlong #ParBlock_FSTInfo 
1655 073D F4 2B 20              pea   $202b                    ;GetFSTInfo
1656 0740 22 B0 00 E1           jsl   $e100b0
1657 0744 B0 0B                 bcs   @notFound
1658 0746 AD 5B 0C              lda   fstID_FSTInfo
1659 0749 CD 55 0C              cmp   targetFST
1660 074C D0 E6                 bne   @search
1661 074E 9C 55 0C              stz   targetFST
1662 0751 AD 55 0C     @notFound lda   targetFST
1663 0754 60                    rts   
1664 0755
1665 0755 00 00        targetFST DC W:0
1666 0757
1667 0757 02 00        ParBlock_FSTInfo DC W:2                 ;pCount=2
1668 0759 00 00        fstnum_FSTInfo DC W:0
1669 075B 00 00        fstID_FSTInfo DC W:0
1670 075D
1671 075D              ***************************************************************
1672 075D              *
1673 075D              * AskWhatToDo
1674 075D              *
1675 075D              * Input:  A = file system ID (0=could not identify)
1676 075D              *         <dataIn = device number
1677 075D              *         DInfo call has been made on DInfoParms block
1678 075D              *
1679 075D              * Output: SEC if we handled the request & put a valid result
1680 075D              *         into [dataOut],4
1681 075D              *
1682 075D              ***************************************************************
1683 075D A8           AskWhatToDo tay   
1684 075E F0 4D                 beq   @nothing
1685 0760
1686 0760 AD 0C 0C              lda   FormatDeviceName
1687 0763 EB                    xba   
1688 0764 8D 0C 0C              sta   FormatDeviceName
1689 0767
1690 0767 48                    pha   
1691 0768 48                    pha   
1692 0769 5A                    phy   
1693 076A F4 0C 00              pea   12                       ;3 substitution strings per fsid
1694 076D A2 0B 09 22           _Multiply 
1695 0774 FA                    plx   
1696 0775 68                    pla   
1697 0776
1698 0776 48                    pha                            ;space for AlertWindow result
1699 0777 F4 21 00              pea   $0021                    ;button positions + Pascal sub strings
1700 077A F4 02 00              pea   subTable>>16
1701 077D 8A                    txa   
1702 077E 18                    clc   
1703 077F 69 FA 0C              adc   #subTable
1704 0782 48                    pha   
1705 0783 F4 02 00 F4           pushlong #theMessage 
1706 0789 A2 04 CA 22           _InitCursor 
1707 0790 A2 0E 59 22           _AlertWindow 
1708 0797 68                    pla                            ;button number
1709 0798              *** added 30-Apr-91 DAL
1710 0798 F0 0C                 beq   @zero
1711 079A              ; if they held down the Option key, turn the Init request into an Erase request
1712 079A AA                    tax   
1713 079B AF 25 C0 E0           lda   >$e0c025
1714 079F 29 40 00              and   #$0040
1715 07A2 F0 01                 beq   @notErase
1716 07A4 E8                    inx   
1717 07A5 8A           @notErase txa   
1718 07A6              @zero     
1719 07A6              *** end of 30-Apr-91 DAL
1720 07A6 A0 04 00              ldy   #4
1721 07A9 97 0E                 sta   [<dataOut],y
1722 07AB 38                    sec   
1723 07AC 60                    rts   
1724 07AD
1725 07AD 18           @nothing clc   
1726 07AE 60                    rts   
1727 07AF
1728 07AF 37 34 7C 54  theMessage DC B:'74|The disk in device *0 appears to be in *1 format.  '
1729 07E5 2A 32                 DC B:'*2'                      ;informational string (no FST/use Installer...)
1730 07E7 7C 5E 45 6A           DC B:'|^Eject|Initialize',0
1731 07FA
1732 07FA              ***************************************************************
1733 07FA
1734 07FA 00 00 00 00  subTable DC L:0,0,0                     ;fsid_reserved
1735 0806 0D 0C 02 00           DC L:devname+1,nameProDOS,msgProDOS ;fsid_ProDOS
1736 0812 0D 0C 02 00           DC L:devname+1,nameDOS33,msgDOS33 ;fsid_DOS33
1737 081E 00 00 00 00           DC L:0,0,0                     ;devname+1,nameDOS32,msgDOS32	;fsid_DOS32
1738 082A 0D 0C 02 00           DC L:devname+1,namePascal,msgPascal ;fsid_Pascal
1739 0836 0D 0C 02 00           DC L:devname+1,nameMFS,msgMFS  ;fsid_MFS
1740 0842 0D 0C 02 00           DC L:devname+1,nameHFS,msgHFS  ;fsid_HFS
1741 084E 00 00 00 00           DC L:0,0,0                     ;devname+1,nameLisa,msgLisa	;fsid_Lisa
1742 085A 00 00 00 00           DC L:0,0,0                     ;devname+1,nameCPM,msgCPM	;fsid_CPM
1743 0866 00 00 00 00           DC L:0,0,0                     ;fsid_reserved (9)
1744 0872 0D 0C 02 00           DC L:devname+1,nameMSDOS,msgMSDOS ;fsid_MSDOS
1745 087E 0D 0C 02 00           DC L:devname+1,nameHighSierra,msgHighSeirra ;fsid_HighSierra
1746 088A 0D 0C 02 00           DC L:devname+1,nameISO9660,msgISO9660 ;fsid_ISO9660
1747 0896 00 00 00 00           DC L:0,0,0                     ;devname+1,nameAppleShare,msgAppleShare	;fsid_AppleShare
1748 08A2 0D 0C 02 00           DC L:devname+1,nameDOS33,msgDOS33other ;fakefsid_DOS33other
1749 08AE
1750 08AE                       string pascal
1751 08AE 06 50 72 6F  nameProDOS DC B:'ProDOS'
1752 08B5 4B 49 6E 73  msgProDOS DC B:'Installing the ProDOS File System Translator allows GS/OS to use this disk.'
1753 0901
1754 0901 10 41 70 70  nameDOS33 DC B:'Apple II DOS 3.3'
1755 0912 5B 49 6E 73  msgDOS33 DC B:'Installing “File System: DOS 3.3 FST” (using the Installer) allows GS/OS to read this disk.'
1756 096E 4F 54 68 65  msgDOS33other DC B:'The DOS 3.3 File System Translator in System 6.0.1 works only with 5.25" disks.'
1757 09BE
1758 09BE              ;nameDOS32	dc.b	'Apple II DOS 3.2 or DOS 3.1'
1759 09BE              ;msgDOS32	dc.b	'System 6.0.1 cannot read DOS 3.2 or DOS 3.1 disks.'
1760 09BE
1761 09BE 0F 41 70 70  namePascal DC B:'Apple II Pascal'
1762 09CE 5A 49 6E 73  msgPascal DC B:'Installing “File System: Pascal FST” (using the Installer) allows GS/OS to read this disk.'
1763 0A29
1764 0A29 0D 4D 61 63  nameMFS  DC B:'Macintosh MFS'
1765 0A37 48 53 79 73  msgMFS   DC B:'System 6.0.1 cannot read MFS disks, but it can use the newer HFS format.'
1766 0A80
1767 0A80 03 48 46 53  nameHFS  DC B:'HFS'
1768 0A84 7C 49 6E 73  msgHFS   DC B:'Installing “File System: HFS FST” (using the Installer) allows GS/OS to use this disk.  HFS is used widely on the Macintosh.'
1769 0B01
1770 0B01              ;nameLisa	dc.b	'Apple Lisa'
1771 0B01              ;msgLisa	dc.b	'System 6.0.1 cannot read Lisa disks.'
1772 0B01
1773 0B01              ;nameCPM	dc.b	'CP/M'
1774 0B01              ;msgCPM	dc.b	'System 6.0.1 cannot read CP/M disks.'
1775 0B01
1776 0B01 06 4D 53 2D  nameMSDOS DC B:'MS-DOS'
1777 0B08              ;msgMSDOS	dc.b	'An MS-DOS File System Translator is required to use this disk.'
1778 0B08 5A 49 6E 73  msgMSDOS DC B:'Installing “File System: MS-DOS FST” (using the Installer) allows GS/OS to read this disk.' ;9-Jun-92 DAL
1779 0B63
1780 0B63 0B 48 69 67  nameHighSierra DC B:'High Sierra'
1781 0B6F              msgISO9660  
1782 0B6F 50 49 6E 73  msgHighSeirra DC B:'Installing “Drive: CD-ROM” (using the Installer) allows GS/OS to read this disk.'
1783 0BC0
1784 0BC0 08 49 53 4F  nameISO9660 DC B:'ISO 9660'
1785 0BC9
1786 0BC9              ;nameAppleShare	dc.b	'AppleShare'
1787 0BC9              ;msgAppleShare	dc.b	'Please re-install the AppleShare software.'
1788 0BC9
1789 0BC9                       string asis 
1790 0BC9              ***************************************************************
1791 0BC9
1792 0BC9                       EndP 
1793 0BC9
1794 0BC9                       END   
